/*
	Ellipse generator.
	Generates an ellipse, centered at CAP.
	Shape given by ax**2 + by**2 - ab = 0.	
*/

#include <stdio.h>
#include <math.h>

double sqrt();
long atol();

long	fx,
	fy,
	fxx,
	fyy;

long	falpha,
	fX,
	fY,
	fXY;

long	absfX,
	absfY,
	absfXY;
/*
int	deltax, deltay;
*/

int	ox,oy;		/* Coordinates of (0,0) centered ellipse. */
int	cx,cy;		/* Center of the actual ellipse */
int	px,py,		/* Coordinates of current points */
	mx,my;		/* on the actual ellipse	*/

long	a,b;

main(argc,argv)
int argc;
char **argv;
{
	long xsemi, ysemi;

	xsemi = 100L;
	ysemi = 49L;
	
	if(argc == 3){
		xsemi = atol(argv[1]);
		ysemi = atol(argv[2]);
	}

	for(;;){
		fibelp(xsemi,ysemi);
		xsemi += ysemi;
		fibelp(xsemi,ysemi);		
		ysemi += xsemi;
	}		
}
fibelp(x,y)
long x,y;
{

	ox = x;
	oy = 0;

	cx = 512;
	cy = 385;
	px = cx + ox;
	py = cy;
	mx = cx - ox;
	my = cy;

	b = x*x;
	a = y*y;

	fxx = a<<1;
	fyy = b<<1;

	fx = x*fxx;
	fy = 0;

	falpha = 0;
	
	for(;;){
/*
		dxdy();
*/
		plot();
		feasibles();
		step();
		if(ox < 0)
			return;
/*
		partials();
*/
	}
}

plot()
{
	mov(px,py);
	wpx(2);
	mov(px,my);
	wpx(2);
	mov(mx,my);
	wpx(2);
	mov(mx,py);
	wpx(2);
}

feasibles()
{
/*
	fX = falpha + fx*deltax + (fxx>>1);
	fY = falpha + fy*deltay + (fyy>>1);
*/
	fX = falpha - fx + a;
	fY = falpha + fy + b;

	fXY = fY + fX - falpha;

	absfX = fX > 0 ? fX : -fX;
	absfY = fY > 0 ? fY : -fY;
	absfXY = fXY > 0 ? fXY : -fXY;
}

step()
{
	if(absfX < absfY)
		if(absfX < absfXY){ /* step in x */
			falpha = fX;
			fx -= fxx;
			px--;
			mx++;
			ox--;
		}
		else{			/* step in x,y */
			falpha = fXY;
			fx -= fxx;
			fy += fyy;
			px--;
			mx++;
			py++;
			my--;
			ox--;
		}
	else
	if(absfY < absfXY){/* step in y */
		falpha = fY;
		fy += fyy;
		py++;
		my--;
	}
	else{			/* step in x,y */
		falpha = fXY;
		fx -= fxx;
		fy += fyy;
		px--;
		mx++;
		py++;
		my--;
		ox--;
	}
}


/*
	The function of this routine has been moved
	to the cases of step() above, where we know
	if one of the deltas is zero.

partials()
{
	fx += fxx*deltax;
	fy += fyy*deltay;
}
*/
/*
	This is not needed for the special case this program
	handles.  deltax here is always -1, deltay always 1.
	The other routines have been modified to take this into
	account.

dxdy()
{
	deltax = fy < 0 ? 1 : -1;
	deltay = fx < 0 ? -1 : 1;
}
*/
